/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mobile.uib;

import com.ibm.mobile.uib.ErrorPage;
import com.ibm.mobile.uib.plugins.CorePluginLoadFailedException;
import com.ibm.mobile.uib.plugins.PluginManager;
import com.ibm.mobile.uib.plugins.PluginTabBar;
import com.ibm.mobile.uib.plugins.VisualPlugin;
import com.ibm.mobile.uib.plugins.core.lang.Translator;
import com.ibm.mobile.uib.plugins.core.prefs.PreferencesManager;
import com.ibm.mobile.uib.util.Style;
import com.ibm.rtk.CustomForm;
import com.ibm.rtk.FormAttachment;
import com.ibm.rtk.FormData;
import com.ibm.rtk.StandardForm;
import com.ibm.rtk.StringWidget;
import com.ibm.rtk.Toolkit;
import com.ibm.rtk.ValueListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class UniversalCommunicator
extends MIDlet
implements ValueListener,
CommandListener {
    protected static UniversalCommunicator singleton;
    protected static Translator translator;
    public static String APPLICATION_NAME;
    private PluginTabBar homeTabBar = null;
    private VisualPlugin[] tabBarPlugins;
    private VisualPlugin currentPlugin;
    private Command exitCmd;
    PreferencesManager.GeneralPreference gp = null;
    static /* synthetic */ Class class$0;

    public UniversalCommunicator() {
        singleton = this;
    }

    public static synchronized UniversalCommunicator getInbox() {
        return singleton;
    }

    private final void initialise() {
        this.applyStyle();
        SplashScreen splash = new SplashScreen();
        Toolkit.setCurrent(this, splash.getForm());
        try {
            PluginManager pluginManager = PluginManager.getManager();
            pluginManager.loadCorePlugins(this);
            this.gp = PreferencesManager.getInstance().getGeneralPreferences();
            Style.setDefaultFontSize(this.gp.getFontSize());
            pluginManager.loadUserPlugins(this);
        }
        catch (CorePluginLoadFailedException e2) {
            this.handleInitFailure(e2);
            return;
        }
        translator = (Translator)PluginManager.getManager().getPlugin("Language");
        APPLICATION_NAME = translator.getKey("uc.title");
        this.exitCmd = new Command(translator.getKey("uc.exit"), 7, 1000);
        this.registerSettingsPlugin();
        this.setupPluginTabbedBar();
        this.enablePlugins();
        Toolkit.MarqueColor = this.gp.getFocusColour();
        splash = null;
    }

    protected final void enablePlugins() {
        PluginManager pluginManager = PluginManager.getManager();
        pluginManager.enableAllPlugins();
    }

    protected final void applyStyle() {
        Toolkit.formimagebg = null;
    }

    protected void destroyApp(boolean unconditional) throws MIDletStateChangeException {
    }

    protected final void pauseApp() {
    }

    protected final void startApp() throws MIDletStateChangeException {
        this.initialise();
    }

    protected final void handleInitFailure(CorePluginLoadFailedException e2) {
        String msg = "Failed to load a core component called " + e2.getPluginName() + ". Reason: " + e2.getCause().getMessage();
        ErrorPage errPage = new ErrorPage(msg, this, true);
        Toolkit.setCurrent(this, errPage);
        Exception cause = e2.getCause();
        if (cause != null) {
            cause.printStackTrace();
        } else {
            e2.printStackTrace();
        }
    }

    protected void setupPluginTabbedBar() {
        this.homeTabBar = new PluginTabBar(this);
        this.homeTabBar.tabunselect = 0xDDDDDC;
        this.homeTabBar.tabback = 0x919191;
        PluginManager pluginManager = PluginManager.getManager();
        Vector visualPlugins = pluginManager.getVisualPlugins();
        Enumeration visualPluginsEnum = visualPlugins.elements();
        this.tabBarPlugins = new VisualPlugin[visualPlugins.size()];
        int i2 = 0;
        while (i2 < this.tabBarPlugins.length && visualPluginsEnum.hasMoreElements()) {
            VisualPlugin plugin;
            this.tabBarPlugins[i2] = plugin = (VisualPlugin)visualPluginsEnum.nextElement();
            this.addGlobalCommands(plugin);
            this.homeTabBar.addTab(plugin);
            ++i2;
        }
        this.homeTabBar.setListener(this);
        if (!visualPlugins.isEmpty()) {
            this.currentPlugin = this.tabBarPlugins[0];
            this.homeTabBar.setSelectedTab(0);
        }
    }

    private final void addGlobalCommands(VisualPlugin plugin) {
        plugin.addCommand(this.exitCmd, this);
    }

    public boolean valueNotify(int index, Object object) {
        VisualPlugin plugin;
        this.currentPlugin.lostFocus();
        this.currentPlugin = plugin = this.tabBarPlugins[index];
        plugin.hasFocus();
        return true;
    }

    public final Display getDisplay() {
        return Display.getDisplay((MIDlet)this);
    }

    public void requestTabDisplayChange(StandardForm form, Object obj) {
        if (obj != null) {
            int count = this.tabBarPlugins.length;
            int i2 = 0;
            while (i2 < count) {
                StandardForm tabForm = this.tabBarPlugins[i2].getDisplay();
                if (form == tabForm) {
                    this.homeTabBar.setTab(obj, form, i2);
                    this.homeTabBar.repaintExt();
                    return;
                }
                ++i2;
            }
        }
    }

    public void requestDisplay(StandardForm form) {
        int count = this.tabBarPlugins.length;
        int i2 = 0;
        while (i2 < count) {
            StandardForm tabForm = this.tabBarPlugins[i2].getDisplay();
            if (form == tabForm) {
                this.homeTabBar.setSelectedTab(i2);
                return;
            }
            ++i2;
        }
    }

    public final void commandAction(Command aCommand, Displayable aDisplayable) {
        if (aCommand.getCommandType() == 7) {
            this.confirmExit();
        }
    }

    private final void confirmExit() {
        CustomForm cf = Toolkit.getCurrentForm();
        if (cf != null) {
            ExitDialog ed = new ExitDialog(cf);
            if (cf instanceof StandardForm) {
                Style.showAsDialog((StandardForm)cf, ed, 2);
            }
        } else {
            this.tidyUp();
        }
    }

    private final void tidyUp() {
        this.notifyDestroyed();
    }

    protected final void registerSettingsPlugin() {
        try {
            PluginManager pluginManager = PluginManager.getManager();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.ibm.mobile.uib.SettingsScreen");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            pluginManager.loadPlugin(clazz.getName(), this);
        }
        catch (Exception exception) {
            Exception e2 = exception;
            exception.printStackTrace();
        }
    }

    protected final Image rescaleImage(Image image, int width, int height) {
        int sourceWidth = image.getWidth();
        int sourceHeight = image.getHeight();
        Image newImage = Image.createImage((int)width, (int)height);
        Graphics g2 = newImage.getGraphics();
        int y2 = 0;
        while (y2 < height) {
            int x2 = 0;
            while (x2 < width) {
                g2.setClip(x2, y2, 1, 1);
                int dx = x2 * sourceWidth / width;
                int dy = y2 * sourceHeight / height;
                g2.drawImage(image, x2 - dx, y2 - dy, 20);
                ++x2;
            }
            ++y2;
        }
        return Image.createImage((Image)newImage);
    }

    private final class ExitDialog
    extends StandardForm
    implements CommandListener {
        private Command yesCmd = new Command(translator.getKey("uc.yes"), 4, 1);
        private Command noCmd = new Command(translator.getKey("uc.no"), 3, 1);
        private StringWidget msg;
        private CustomForm parent;

        ExitDialog(CustomForm parent) {
            this.parent = parent;
            UniversalCommunicator.this.gp = PreferencesManager.getInstance().getGeneralPreferences();
            ExitDialog exitDialog = this;
            exitDialog.setCommandListener(exitDialog);
            this.msg = new StringWidget(translator.getKey("uc.sureexit"), false);
            this.msg.setStyle(0, Style.getDefaultFont(), false, 2);
            FormData data = new FormData();
            new FormData().left = new FormAttachment(0, 2);
            data.right = new FormAttachment(100, -2);
            data.top = new FormAttachment(0, 2);
            data.bottom = new FormAttachment(100, -2);
            this.msg.setLayoutData(data);
            ExitDialog exitDialog2 = this;
            exitDialog2.append(exitDialog2.msg);
            ExitDialog exitDialog3 = this;
            exitDialog3.addCommand(exitDialog3.yesCmd);
            ExitDialog exitDialog4 = this;
            exitDialog4.addCommand(exitDialog4.noCmd);
        }

        public final void commandAction(Command c2, Displayable d2) {
            if (this.parent instanceof StandardForm) {
                ((StandardForm)this.parent).removeCommand(this.yesCmd);
                ((StandardForm)this.parent).removeCommand(this.noCmd);
                ((StandardForm)this.parent).dismissDialog();
            }
            if (c2 == this.yesCmd) {
                UniversalCommunicator.getInbox().tidyUp();
            }
        }
    }

    protected final class SplashScreen {
        String DEFAULT_LOGO_NAME = "/images/splash.png";
        StandardForm form;

        public SplashScreen() {
            this.initialise();
        }

        private final void initialise() {
            this.form = new StandardForm();
            UniversalCommunicator.this.gp = PreferencesManager.getInstance().getGeneralPreferences();
            try {
                Image bg = Toolkit.createImage(UniversalCommunicator.this.gp.getDefaultBGImageName());
                this.form.setBackground(bg, 0xFFFFFF);
            }
            catch (IOException bg) {
                // empty catch block
            }
            Image logo = null;
            Image rescaledLogo = null;
            try {
                String logoName = UniversalCommunicator.this.gp.getSplashScreenLogo();
                logo = Toolkit.createImage(logoName);
            }
            catch (Exception e2) {
                String logoName = this.DEFAULT_LOGO_NAME;
                try {
                    logo = Toolkit.createImage(logoName);
                }
                catch (Exception exception) {
                    Exception ex = exception;
                    exception.printStackTrace();
                }
            }
            rescaledLogo = logo;
            if (logo != null) {
                double ratioHeigth;
                double ratioWidth = (double)this.form.getWidth() / (double)logo.getWidth();
                if (ratioWidth < (ratioHeigth = (double)this.form.getHeight() / (double)logo.getHeight())) {
                    Image image = logo;
                    rescaledLogo = UniversalCommunicator.this.rescaleImage(image, (int)((double)image.getWidth() * ratioWidth), (int)((double)logo.getHeight() * ratioWidth));
                } else {
                    Image image = logo;
                    rescaledLogo = UniversalCommunicator.this.rescaleImage(image, (int)((double)image.getWidth() * ratioHeigth), (int)((double)logo.getHeight() * ratioHeigth));
                }
            }
            StringWidget logoStr = new StringWidget(rescaledLogo, null, false);
            FormData data = new FormData();
            new FormData().left = new FormAttachment(0, (this.form.getWidth() - rescaledLogo.getWidth()) / 2);
            data.top = new FormAttachment(0, (this.form.getHeight() - rescaledLogo.getHeight()) / 2);
            logoStr.setLayoutData(data);
            this.form.append(logoStr);
        }

        public final StandardForm getForm() {
            return this.form;
        }
    }
}

