/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mobile.uib;

import com.ibm.mobile.uib.common.Dialog;
import com.ibm.mobile.uib.plugins.AbstractPlugin;
import com.ibm.mobile.uib.plugins.PluginManager;
import com.ibm.mobile.uib.plugins.alerter.Alerter;
import com.ibm.mobile.uib.plugins.core.lang.Translator;
import com.ibm.mobile.uib.plugins.core.prefs.PreferenceException;
import com.ibm.mobile.uib.plugins.core.prefs.PreferencesManager;
import com.ibm.mobile.uib.util.Style;
import com.ibm.rtk.CheckWidget;
import com.ibm.rtk.Composite;
import com.ibm.rtk.FormAttachment;
import com.ibm.rtk.FormData;
import com.ibm.rtk.StandardForm;
import com.ibm.rtk.StringWidget;
import com.ibm.rtk.TextfieldWidget;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;

public final class SettingsScreen
extends AbstractPlugin
implements CommandListener,
Dialog {
    private static String PLUGIN_NAME = "Settings";
    private StandardForm parent;
    private Command saveCmd;
    private Command cancelCmd;
    private TextfieldWidget userField;
    private TextfieldWidget brokerField;
    private CheckWidget vibChk;
    private CheckWidget flashChk;
    private CheckWidget audibleChk;
    private CheckWidget fsChk;
    private PreferencesManager.GeneralPreference gp = PreferencesManager.getInstance().getGeneralPreferences();
    private Alerter alerter = (Alerter)((Object)PluginManager.getManager().getPlugin("Alerter"));
    private Translator translator = (Translator)PluginManager.getManager().getPlugin("Language");
    private StandardForm mainDisplay;

    public SettingsScreen() {
        super(PLUGIN_NAME);
        this.initialiseDisplay();
    }

    protected final void initialiseDisplay() {
        this.mainDisplay = new StandardForm();
        FormData data = null;
        int textColour = this.gp.getDefaultTextColour();
        Font font = Style.getDefaultFont();
        data = new FormData();
        new FormData().top = new FormAttachment(2);
        data.left = new FormAttachment(0, 2);
        StringWidget title = Style.createTitlebar(this.translator.getKey("homepage.settings"), null, 0, textColour);
        title.setLayoutData(data);
        this.mainDisplay.append(title);
        this.userField = new TextfieldWidget(this.translator.getKey("settingsscreen.username"), 8, 23, 1, 8208, font);
        this.userField.labelfg = textColour;
        data = new FormData();
        new FormData().top = new FormAttachment(title, 5);
        data.left = new FormAttachment(0, 5);
        this.userField.setLayoutData(data);
        this.mainDisplay.append(this.userField);
        this.brokerField = new TextfieldWidget(this.translator.getKey("settingsscreen.broker"), 8, 25, 1, 8208, font);
        this.brokerField.labelfg = textColour;
        data = new FormData();
        new FormData().top = new FormAttachment(this.userField, 3);
        data.left = new FormAttachment(0, 5);
        this.brokerField.setLayoutData(data);
        this.mainDisplay.append(this.brokerField);
        Composite alertComp = new Composite(this.translator.getKey("settingsscreen.alertnotification"), true, 0, 2, 0);
        alertComp.setTwistyFG(textColour);
        alertComp.border = textColour;
        data = new FormData();
        new FormData().top = new FormAttachment(this.brokerField, 5);
        alertComp.setLayoutData(data);
        this.vibChk = new CheckWidget(this.translator.getKey("settingsscreen.vibrate"), font);
        this.vibChk.fg = textColour;
        data = new FormData();
        new FormData().top = new FormAttachment(null, 3);
        this.vibChk.setLayoutData(data);
        this.flashChk = new CheckWidget(this.translator.getKey("settingsscreen.flashing"), font);
        this.flashChk.fg = textColour;
        data = new FormData();
        new FormData().top = new FormAttachment(this.vibChk, 3);
        this.flashChk.setLayoutData(data);
        this.audibleChk = new CheckWidget(this.translator.getKey("settingsscreen.audio"), font);
        this.audibleChk.fg = textColour;
        data = new FormData();
        new FormData().top = new FormAttachment(this.flashChk, 3);
        this.audibleChk.setLayoutData(data);
        alertComp.append(this.vibChk);
        alertComp.append(this.flashChk);
        alertComp.append(this.audibleChk);
        this.mainDisplay.append(alertComp);
        this.fsChk = new CheckWidget(this.translator.getKey("settingsscreen.fullscreen"), font);
        this.fsChk.fg = textColour;
        data = new FormData();
        new FormData().top = new FormAttachment(alertComp, 5);
        data.left = new FormAttachment(0, 2);
        this.fsChk.setLayoutData(data);
        this.mainDisplay.append(this.fsChk);
        this.saveCmd = new Command(this.translator.getKey("settingsscreen.save"), 4, 1);
        this.mainDisplay.addCommand(this.saveCmd);
        this.cancelCmd = new Command(this.translator.getKey("settingsscreen.cancel"), 3, 2);
        this.mainDisplay.addCommand(this.cancelCmd);
        this.mainDisplay.setCommandListener(this);
    }

    public final void commandAction(Command c2, Displayable d2) {
        if (c2 == this.saveCmd) {
            try {
                this.gp.setDefaultClientID(this.userField.getText());
                this.gp.setDefaultBroker(this.brokerField.getText());
                this.gp.setFullScreen(this.fsChk.selected);
                if (this.alerter != null) {
                    this.alerter.setPrefs(this.vibChk.selected, this.flashChk.selected, this.audibleChk.selected);
                }
                this.gp.store();
            }
            catch (PreferenceException preferenceException) {
                PreferenceException e2 = preferenceException;
                preferenceException.printStackTrace();
            }
            this.parent.dismissDialog();
        } else if (c2 == this.cancelCmd) {
            this.parent.dismissDialog();
        }
    }

    public final void show(StandardForm parent) {
        this.userField.setText(this.gp.getDefaultClientID());
        this.brokerField.setText(this.gp.getDefaultBroker());
        this.fsChk.setSelection(this.gp.useFullscreen());
        if (this.alerter != null) {
            this.vibChk.selected = this.alerter.willVibrate();
            this.flashChk.selected = this.alerter.willFlash();
            this.audibleChk.selected = this.alerter.isAudible();
        }
        this.parent = parent;
        int gap = 10;
        int screenWidth = parent.getWidth();
        int screenHeight = parent.getHeight();
        int n2 = gap;
        parent.showAsDialog(this.mainDisplay, n2, n2, screenWidth - (gap << 1), screenHeight - (gap << 1), 1);
    }
}

