/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mia.classic.map;

import com.ibm.cst.ui.embedded.api.viewer.MapViewerPlugin;
import com.ibm.cst.ui.embedded.map.ILayer;
import com.ibm.cst.ui.embedded.map.Map;
import com.ibm.mia.classic.action.ClassicActionsManager;
import com.ibm.mobile.uib.plugins.core.prefs.Preferences;
import com.ibm.uif.fsl.common.client.payload.CommonPayload;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;

public abstract class ClassicMapPlugin
extends MapViewerPlugin {
    private Map map;
    private int floor = 1;

    public final void commandAction(Command aCommand, Displayable aDisplayable) {
        if (aCommand == ClassicActionsManager.getClassicActionsManager().getZoomInAction()) {
            this.$mapViewer.zoomIn();
        } else if (aCommand == ClassicActionsManager.getClassicActionsManager().getZoomOutAction()) {
            this.$mapViewer.zoomOut();
        } else if (aCommand == ClassicActionsManager.getClassicActionsManager().getFullExtendAction()) {
            this.$mapViewer.toMapPlan();
        } else if (aCommand == ClassicActionsManager.getClassicActionsManager().getToItineraryAction()) {
            this.$mapViewer.toItinerary();
        } else {
            super.commandAction(aCommand, aDisplayable);
        }
    }

    public abstract void removeManagedActions();

    public abstract void addManagedActions();

    public void initialise(Preferences preferences) {
        super.initialise(preferences);
        this.getDisplay().removeCommand(this.$zoomIn);
        this.getDisplay().removeCommand(this.$zoomOut);
        this.getDisplay().removeCommand(this.$fullExtent);
    }

    protected final void showImage(CommonPayload pl) {
        super.showImage(pl);
        this.refreshFloor();
        this.getDisplay().removeCommand(this.$toItinerary);
        if (this.$mapViewer.getItinerary() != null && this.$mapViewer.getItinerary().length > 0) {
            this.getDisplay().addCommand(ClassicActionsManager.getClassicActionsManager().getToItineraryAction());
        } else {
            this.getDisplay().removeCommand(ClassicActionsManager.getClassicActionsManager().getToItineraryAction());
        }
    }

    protected final Map loadMap(String mapFileSpec) {
        this.map = super.loadMap(mapFileSpec);
        this.setFloor(1);
        return this.map;
    }

    public final void setFloor(int f2) {
        this.floor = f2;
        this.refreshFloor();
    }

    protected final void refreshFloor() {
        ILayer[] layers = this.map.getLayers();
        int i2 = 0;
        while (i2 < layers.length) {
            ILayer l2 = layers[i2];
            if (l2.getName().indexOf("Floor_") != -1) {
                if (l2.getName().endsWith("" + this.floor)) {
                    l2.setVisible(true);
                } else {
                    l2.setVisible(false);
                }
            }
            ++i2;
        }
        this.mainDisplay.repaint();
    }

    public final boolean keyPressed(int keyCode) {
        boolean bUnHandled = false;
        if (!this.responseActionsInList) {
            if (keyCode == -4) {
                this.$mapViewer.toEast();
            } else if (keyCode == -3) {
                this.$mapViewer.toWest();
            } else if (keyCode == -1) {
                this.$mapViewer.toNorth();
            } else if (keyCode == -2) {
                this.$mapViewer.toSouth();
            } else {
                bUnHandled = !super.keyPressed(keyCode);
            }
        } else {
            bUnHandled = !super.keyPressed(keyCode);
        }
        return !bUnHandled;
    }
}

