/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cst.ui.embedded.map;

import com.ibm.cst.ui.embedded.geometry.IEnvelope;
import com.ibm.cst.ui.embedded.geometry.IGeometry;
import com.ibm.cst.ui.embedded.geometry.ILineString;
import com.ibm.cst.ui.embedded.geometry.IPoint;
import com.ibm.cst.ui.embedded.graphics.Color;
import com.ibm.cst.ui.embedded.graphics.ISpatialGC;
import com.ibm.cst.ui.embedded.list.ISpatialCoordinateList;
import com.ibm.cst.ui.embedded.map.Layer;
import com.ibm.rtk.Toolkit;
import java.io.IOException;
import java.util.Enumeration;
import javax.microedition.lcdui.Image;

public final class Path
extends Layer {
    private Color $startBackColor = Color.BLACK;
    private Color $startForeColor = Color.RED;
    private Color $endBackColor = Color.BLACK;
    private Color $endForeColor = Color.GREEN;
    Image $dest = null;

    public Path() {
        this.loadPointIcon();
    }

    public final void draw(ISpatialGC gc, IEnvelope mapArea) {
        Enumeration enumGeos = this.getGeoListElements();
        while (enumGeos.hasMoreElements()) {
            ISpatialCoordinateList coords;
            IGeometry geom = (IGeometry)enumGeos.nextElement();
            if (geom instanceof ILineString) {
                if (!this.isShown(gc, geom)) continue;
                gc.setLineWidth(3);
                super.draw(gc, mapArea);
                coords = ((ILineString)geom).getCoordinates();
                gc.setLineWidth(1);
                continue;
            }
            if (!(geom instanceof IPoint) || !this.isShown(gc, geom)) continue;
            ISpatialCoordinateList iSpatialCoordinateList = coords = ((IPoint)geom).getCoordinates();
            gc.drawImage(this.$dest, iSpatialCoordinateList.get(iSpatialCoordinateList.length() - 1));
        }
    }

    protected final void loadPointIcon() {
        try {
            this.$dest = Toolkit.createImage("/images/dest.png");
        }
        catch (IOException iOException) {
            IOException e2 = iOException;
            iOException.printStackTrace();
        }
    }

    protected final Image getPointIcon() {
        return this.$dest;
    }
}

