/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cst.ui.embedded.map;

import com.ibm.cst.ui.embedded.factory.impl.GeometryFactory;
import com.ibm.cst.ui.embedded.geometry.IEnvelope;
import com.ibm.cst.ui.embedded.graphics.ISpatialGC;
import com.ibm.cst.ui.embedded.map.ILayer;
import com.ibm.cst.ui.embedded.map.IMap;
import com.ibm.cst.ui.embedded.map.Layer;
import java.util.Enumeration;
import java.util.Vector;

public final class Map
implements IMap {
    private String $name;
    private Vector $layersList;
    private IEnvelope $extent;

    public Map() {
        this("NoName");
    }

    public Map(String name) {
        this(name, GeometryFactory.getInstance().createEnvelope());
    }

    public Map(String name, IEnvelope extent) {
        this.$name = name;
        this.$extent = extent;
        this.$layersList = new Vector();
    }

    public final int addLayer(ILayer layer) {
        int layerIndex = this.findLayer(layer.getName());
        if (layerIndex >= 0) {
            this.clearLayer(layerIndex);
        }
        this.$layersList.addElement(layer);
        return this.$layersList.size() - 1;
    }

    public final int findLayer(String layerName) {
        int layerIndex = -1;
        int layersCount = this.$layersList.size();
        int iL = 0;
        while (layerIndex < 0 && iL < layersCount) {
            if (layerName != null && layerName.equals(this.getLayer(iL).getName())) {
                layerIndex = iL;
            }
            ++iL;
        }
        return layerIndex;
    }

    public final ILayer getLayer(int idxLayer) {
        return idxLayer < this.$layersList.size() ? (ILayer)this.$layersList.elementAt(idxLayer) : null;
    }

    public final ILayer[] getLayers() {
        ILayer[] tab = new Layer[this.$layersList.size()];
        int i2 = 0;
        while (i2 < tab.length) {
            tab[i2] = (ILayer)this.$layersList.elementAt(i2);
            ++i2;
        }
        return tab;
    }

    public final void clearLayer(int i2) {
        if (this.getLayer(i2) != null) {
            this.$layersList.removeElementAt(i2);
        }
    }

    public final IEnvelope getExtent() {
        return this.$extent;
    }

    public final void setExtent(IEnvelope extent) {
        this.$extent = extent;
    }

    public final void draw(ISpatialGC gc, IEnvelope area) {
        gc.setDrawArea(area);
        Enumeration enumLayers = this.$layersList.elements();
        while (enumLayers.hasMoreElements()) {
            ILayer layer = (ILayer)enumLayers.nextElement();
            if (!layer.isVisible()) continue;
            layer.draw(gc, area);
        }
    }
}

