/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cst.ui.embedded.graphics.impl;

import com.ibm.cst.ui.embedded.geometry.IEnvelope;
import com.ibm.cst.ui.embedded.geometry.IGeometry;
import com.ibm.cst.ui.embedded.geometry.ILineString;
import com.ibm.cst.ui.embedded.geometry.IPolygon;
import com.ibm.cst.ui.embedded.geometry.ISpatialCoordinate;
import com.ibm.cst.ui.embedded.graphics.Color;
import com.ibm.cst.ui.embedded.graphics.ISpatialGC;
import com.ibm.cst.ui.embedded.list.ISpatialCoordinateList;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class SpatialGC
implements ISpatialGC {
    private int $lineWidth = 1;
    private Graphics $g;
    private IEnvelope $area;
    private double $zoom = 1.0;
    private double $mapCenterX;
    private double $mapCenterY;
    private int $foreRGB = 0xFFFFFF;
    private int $backRGB = 0;
    private int $lastColor = -1;
    private int $wHalfPels;
    private int $hHalfPels;

    public SpatialGC(Graphics g2, IEnvelope area, int wPels, int hPels) {
        this.$g = g2;
        this.$hHalfPels = hPels / 2;
        this.$wHalfPels = wPels / 2;
        this.setDrawArea(area);
        this.$zoom = this.computeZoom(area, wPels, hPels);
    }

    public final void setDrawArea(IEnvelope area) {
        this.$area = area;
        if (area != null) {
            this.$mapCenterX = area.getCentroid().getX();
            this.$mapCenterY = area.getCentroid().getY();
        }
    }

    private final int[] project(ISpatialCoordinate coord) {
        int[] xyPels = new int[]{(int)((coord.getX() - this.$mapCenterX) / this.$zoom) + this.$wHalfPels, (int)((this.$mapCenterY - coord.getY()) / this.$zoom) + this.$hHalfPels};
        return xyPels;
    }

    private final void project(int[] xyPels, ISpatialCoordinate coord) {
        xyPels[0] = (int)((coord.getX() - this.$mapCenterX) / this.$zoom) + this.$wHalfPels;
        xyPels[1] = (int)((this.$mapCenterY - coord.getY()) / this.$zoom) + this.$hHalfPels;
    }

    protected final double computeZoom(IEnvelope area, int wPels, int hPels) {
        return (this.$area.getWidth() / (double)wPels + this.$area.getHeight() / (double)hPels) / 2.0;
    }

    public final double getZoom() {
        return this.$zoom;
    }

    public final boolean drawAreaContains(IGeometry geo) {
        return this.$area.contains(geo);
    }

    public final boolean drawAreaIntersects(IGeometry geo) {
        return this.$area.intersects(geo);
    }

    public final void drawCrossHair(ISpatialCoordinate coord, int extendPels) {
        SpatialGC spatialGC = this;
        spatialGC.setColor(spatialGC.$foreRGB);
        int[] xyPelsF = this.project(coord);
        int[] xyPelsT = this.project(coord);
        xyPelsF[0] = xyPelsF[0] - extendPels;
        xyPelsT[0] = xyPelsT[0] + extendPels;
        this.drawLine(xyPelsF, xyPelsT);
        xyPelsF = this.project(coord);
        xyPelsT = this.project(coord);
        xyPelsF[1] = xyPelsF[1] - extendPels;
        xyPelsT[1] = xyPelsT[1] + extendPels;
        this.drawLine(xyPelsF, xyPelsT);
    }

    protected final void drawLine(int[] xyPelFrom, int[] xyPelTo) {
        if (!this.isEmpty()) {
            if (this.$lineWidth <= 1) {
                SpatialGC spatialGC = this;
                spatialGC.setColor(spatialGC.$foreRGB);
                this.$g.drawLine(xyPelFrom[0], xyPelFrom[1], xyPelTo[0], xyPelTo[1]);
            } else {
                int w2 = xyPelTo[0] - xyPelFrom[0];
                int h2 = xyPelTo[1] - xyPelFrom[1];
                if (w2 < 0) {
                    w2 = -w2;
                }
                if (h2 < 0) {
                    h2 = -h2;
                }
                if (w2 > h2) {
                    h2 = 1;
                    w2 = 0;
                } else {
                    h2 = 0;
                    w2 = 1;
                }
                SpatialGC spatialGC = this;
                spatialGC.setColor(spatialGC.$foreRGB);
                int iL = 0;
                while (iL < this.$lineWidth) {
                    int offset = iL - this.$lineWidth / 2;
                    this.$g.drawLine(xyPelFrom[0] + offset * w2, xyPelFrom[1] + offset * h2, xyPelTo[0] + offset * w2, xyPelTo[1] + offset * h2);
                    ++iL;
                }
            }
        }
    }

    public final void drawPolyLine(ILineString line) {
        if (!line.isEmpty()) {
            this.draw_internal(line.getCoordinates(), false);
        }
    }

    private final void draw_internal(ISpatialCoordinateList coords, boolean closeFigure) {
        ISpatialCoordinate firstCoord = coords.get(0);
        int coordsCount = coords.length();
        int[] xyLast = this.project(firstCoord);
        int i2 = 1;
        while (i2 < coordsCount) {
            int[] xy = this.project(coords.get(i2));
            if (i2 == 1 || xyLast[0] != xy[0] || xyLast[1] != xy[1]) {
                this.drawLine(xyLast, xy);
                xyLast = xy;
            }
            ++i2;
        }
    }

    public final void drawPolygon(IPolygon poly) {
        if (!poly.isEmpty()) {
            this.draw_internal(poly.getCoordinates(), true);
        }
    }

    public final void drawText(ISpatialCoordinate coord, String text, boolean transparent) {
        SpatialGC spatialGC = this;
        spatialGC.drawText(spatialGC.project(coord), text, transparent);
    }

    protected final void drawText(int[] xyPels, String text, boolean transparent) {
        SpatialGC spatialGC = this;
        spatialGC.setColor(spatialGC.$foreRGB);
        this.$g.drawString(text, xyPels[0], xyPels[1], 20);
    }

    public final void fillOval(ISpatialCoordinate coordCenter, int rayXPels, int rayYPels) {
        int[] xyPels = this.project(coordCenter);
        SpatialGC spatialGC = this;
        spatialGC.setColor(spatialGC.$backRGB);
        int n2 = rayXPels;
        this.$g.fillArc(xyPels[0] - rayXPels / 2, xyPels[1] - rayYPels / 2, n2, n2, 45, 360);
    }

    public final void drawOval(ISpatialCoordinate coordCenter, int rayXPels, int rayYPels) {
        int[] xyPels = this.project(coordCenter);
        SpatialGC spatialGC = this;
        spatialGC.setColor(spatialGC.$foreRGB);
        int n2 = rayXPels;
        this.$g.drawArc(xyPels[0] - rayXPels / 2, xyPels[1] - rayYPels / 2, n2, n2, 45, 360);
    }

    protected final void setColor(int rgb) {
        if (this.$lastColor != rgb) {
            this.$g.setColor(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
            this.$lastColor = rgb;
        }
    }

    public final void fillPolygon(IPolygon poly) {
        if (!poly.isEmpty()) {
            SpatialGC spatialGC = this;
            spatialGC.setColor(spatialGC.$backRGB);
            ISpatialCoordinateList coords = poly.getCoordinates();
            int[] trIdxs = poly.getTrianglesIndices();
            int trCount = trIdxs == null ? 0 : trIdxs.length;
            if (trCount == 0) {
                this.dbg("No Triangles for fill polygon with " + coords.length() + " coordinates");
            } else {
                int[] xyPels0 = new int[2];
                int[] xyPels1 = new int[2];
                int[] xyPels2 = new int[2];
                int iT = 0;
                while (iT < trCount) {
                    this.project(xyPels0, coords.get(trIdxs[iT]));
                    this.project(xyPels1, coords.get(trIdxs[iT + 1]));
                    this.project(xyPels2, coords.get(trIdxs[iT + 2]));
                    if (!(xyPels0[0] == xyPels1[0] && xyPels0[1] == xyPels1[1] || xyPels1[0] == xyPels2[0] && xyPels1[1] == xyPels2[1] || xyPels2[0] == xyPels0[0] && xyPels2[1] == xyPels0[1])) {
                        this.$g.fillTriangle(xyPels0[0], xyPels0[1], xyPels1[0], xyPels1[1], xyPels2[0], xyPels2[1]);
                    }
                    iT += 3;
                }
            }
        }
    }

    public final IEnvelope getDrawArea() {
        return this.$area;
    }

    public final void setFontSize(String size) {
        if (size.equals("small")) {
            this.$g.setFont(Font.getFont((int)32, (int)1, (int)8));
        } else if (size.equals("medium")) {
            this.$g.setFont(Font.getFont((int)32, (int)1, (int)0));
        } else if (size.equals("large")) {
            this.$g.setFont(Font.getFont((int)32, (int)1, (int)16));
        }
    }

    public final boolean isEmpty() {
        return this.$g == null || this.$area == null;
    }

    public final int getWidth() {
        return this.$wHalfPels << 1;
    }

    public final void setForeground(int r, int g2, int b2) {
        this.$foreRGB = ((r & 0xFF) << 16) + ((g2 & 0xFF) << 8) + (b2 & 0xFF);
    }

    public final void setBackground(int r, int g2, int b2) {
        this.$backRGB = ((r & 0xFF) << 16) + ((g2 & 0xFF) << 8) + (b2 & 0xFF);
    }

    public final void setForeground(Color color) {
        this.setForeground(color.r, color.g, color.b);
    }

    public final void setBackground(Color color) {
        this.setBackground(color.r, color.g, color.b);
    }

    public final void setLineWidth(int lineWidth) {
        this.$lineWidth = lineWidth;
    }

    public final void drawEnvelope(IEnvelope envel) {
        this.$g.setColor(this.$foreRGB);
        ISpatialCoordinateList coordinates = envel.getCoordinates();
        int[] xyBR = this.project(coordinates.get(0));
        int[] xyTL = this.project(coordinates.get(2));
        int x2 = xyBR[0];
        int y2 = xyBR[1];
        int w2 = xyTL[0] - xyBR[0];
        int h2 = xyTL[1] - xyBR[1];
        if (w2 < 0) {
            w2 = -w2;
            x2 = xyTL[0];
        }
        if (h2 < 0) {
            h2 = -h2;
            y2 = xyTL[1];
        }
        this.$g.drawRect(x2, y2, w2, h2);
    }

    protected final void dbg(String dbgMsg) {
    }

    public final void drawImage(Image img, ISpatialCoordinate coord) {
        this.drawImage(img, coord, 3);
    }

    public final void drawImage(Image img, ISpatialCoordinate coord, int style) {
        int[] xyPels = this.project(coord);
        this.$g.drawImage(img, xyPels[0], xyPels[1], style);
    }
}

