/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cst.ui.embedded.geometry.operator;

import com.ibm.cst.ui.embedded.geometry.ILineString;
import com.ibm.cst.ui.embedded.geometry.IPolygon;
import com.ibm.cst.ui.embedded.geometry.ISpatialCoordinate;
import com.ibm.cst.ui.embedded.geometry.impl.SpatialCoordinate;
import com.ibm.cst.ui.embedded.list.ISpatialCoordinateList;

public abstract class Util {
    public static boolean lineContainsPoint(ISpatialCoordinate c1, ISpatialCoordinate c2, ISpatialCoordinate c3) {
        if (c3.getX() > Math.max(c1.getX(), c2.getX()) || c3.getX() < Math.min(c1.getX(), c2.getX()) || c3.getY() > Math.max(c1.getY(), c2.getY()) || c3.getY() < Math.min(c1.getY(), c2.getY())) {
            return false;
        }
        ISpatialCoordinate c2Trans = (ISpatialCoordinate)c2.clone();
        c2Trans.translate(-c1.getX(), -c1.getY());
        ISpatialCoordinate cTrans = (ISpatialCoordinate)c3.clone();
        cTrans.translate(-c1.getX(), -c1.getY());
        return c2Trans.getY() / c2Trans.getX() == cTrans.getY() / cTrans.getX();
    }

    public static boolean polygoneContainsPoint(IPolygon poly, ISpatialCoordinate p2) {
        boolean contains = false;
        int nbIntersection = 0;
        if (poly.isEmpty() || p2 == null) {
            return false;
        }
        ILineString ray = poly.getFactory().createLineString(poly.getFactory().getListFactory().createSpatialCoordinateList(new ISpatialCoordinate[]{p2, new SpatialCoordinate(poly.getEnvelope().getXmax() + 1.0, p2.getY())}));
        ISpatialCoordinateList coords = poly.getCoordinates();
        int i2 = 0;
        while (i2 < coords.length() - 1) {
            if (ray.intersects(poly.getFactory().createLineString(poly.getFactory().getListFactory().createSpatialCoordinateList(new ISpatialCoordinate[]{coords.get(i2), coords.get(i2 + 1)})))) {
                ++nbIntersection;
            }
            ++i2;
        }
        if (nbIntersection != 0 && nbIntersection % 2 != 0) {
            contains = true;
        }
        return contains;
    }

    public static ISpatialCoordinate segmentIntersection(ISpatialCoordinate a1, ISpatialCoordinate a2, ISpatialCoordinate b1, ISpatialCoordinate b2) {
        double x1 = a1.getX();
        double x2 = a2.getX();
        double x3 = b1.getX();
        double x4 = b2.getX();
        double y1 = a1.getY();
        double y2 = a2.getY();
        double y3 = b1.getY();
        double y4 = b2.getY();
        double denominator = (y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1);
        if (denominator == 0.0) {
            double slope0 = y1 - (y2 - y1) / (x2 - x1) * x1;
            double slope1 = y3 - (y4 - y3) / (x4 - x3) * x3;
            if (slope0 != slope1 || Double.isInfinite(slope0) && x1 != x3) {
                return null;
            }
            return new SpatialCoordinate(x1, y1);
        }
        double ua = ((x4 - x3) * (y1 - y3) - (y4 - y3) * (x1 - x3)) / denominator;
        double ub = ((x2 - x1) * (y1 - y3) - (y2 - y1) * (x1 - x3)) / denominator;
        if (ua < 0.0 || ua > 1.0 || ub < 0.0 || ub > 1.0) {
            return null;
        }
        x1 += ua * (x2 - x1);
        y1 += ua * (y2 - y1);
        return new SpatialCoordinate(x1, y1);
    }
}

