/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cst.ui.embedded.geometry.operator;

import com.ibm.cst.ui.embedded.geometry.IEnvelope;
import com.ibm.cst.ui.embedded.geometry.IGeometry;
import com.ibm.cst.ui.embedded.geometry.ILineString;
import com.ibm.cst.ui.embedded.geometry.IPoint;
import com.ibm.cst.ui.embedded.geometry.IPolygon;
import com.ibm.cst.ui.embedded.geometry.operator.OpIntersect;

public abstract class OpIntersection {
    private static IGeometry interectionEnvelope(IEnvelope env, IGeometry geo) {
        if (geo instanceof IEnvelope) {
            return OpIntersection.envelopeIntersection(env, (IEnvelope)geo);
        }
        return OpIntersection.intersectionPolygonegeo(env.toPolygone(), geo);
    }

    private static IGeometry envelopeIntersection(IEnvelope env, IEnvelope env2) {
        if (env.isEmpty() || env2.isEmpty()) {
            return null;
        }
        if (env2.getXmin() > env.getXmax() || env2.getXmax() < env.getXmin() || env2.getYmin() > env.getYmax() || env2.getYmax() < env.getYmin()) {
            return null;
        }
        if (env.contains(env2)) {
            return env;
        }
        if (env2.contains(env)) {
            return env2;
        }
        return env.getFactory().createEnvelope(Math.max(env.getXmin(), env2.getXmin()), Math.min(env.getXmax(), env2.getXmax()), Math.max(env.getYmin(), env2.getYmin()), Math.min(env.getYmax(), env2.getYmax()));
    }

    private static IGeometry intersectionPointgeo(IPoint p2, IGeometry geo) {
        if (p2.isEmpty() || geo.isEmpty()) {
            return null;
        }
        if (OpIntersect.intersect(p2, geo)) {
            return p2;
        }
        return null;
    }

    private static IGeometry intersectionPolygonegeo(IPolygon poly, IGeometry geo) {
        return null;
    }

    private static IGeometry intersectionLineStringgeo(ILineString line, IGeometry geo) {
        return null;
    }

    public static IGeometry intersection(IGeometry geo1, IGeometry geo2) {
        if (geo1 instanceof IPoint) {
            return OpIntersection.intersectionPointgeo((IPoint)geo1, geo2);
        }
        if (geo1 instanceof ILineString) {
            return OpIntersection.intersectionLineStringgeo((ILineString)geo1, geo2);
        }
        if (geo1 instanceof IPolygon) {
            return OpIntersection.intersectionPolygonegeo((IPolygon)geo1, geo2);
        }
        if (geo1 instanceof IEnvelope) {
            return OpIntersection.interectionEnvelope((IEnvelope)geo1, geo2);
        }
        return null;
    }
}

