/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cst.ui.embedded.geometry.operator;

import com.ibm.cst.ui.embedded.geometry.IEnvelope;
import com.ibm.cst.ui.embedded.geometry.IGeometry;
import com.ibm.cst.ui.embedded.geometry.ILineString;
import com.ibm.cst.ui.embedded.geometry.IPoint;
import com.ibm.cst.ui.embedded.geometry.IPolygon;
import com.ibm.cst.ui.embedded.geometry.impl.LineString;
import com.ibm.cst.ui.embedded.geometry.operator.OpContain;
import com.ibm.cst.ui.embedded.geometry.operator.OpIntersection;
import com.ibm.cst.ui.embedded.geometry.operator.Util;
import com.ibm.cst.ui.embedded.list.ISpatialCoordinateList;

public abstract class OpIntersect {
    private static boolean envelopeIntersects(IEnvelope env, IGeometry geo) {
        if (geo instanceof IEnvelope) {
            return OpIntersection.intersection(env, (IEnvelope)geo) != null;
        }
        return OpIntersect.polygonIntersects(env.toPolygone(), geo);
    }

    private static boolean pointIntersects(IPoint p2, IGeometry geo) {
        if (geo instanceof IPoint) {
            return OpContain.contains(p2, geo);
        }
        ISpatialCoordinateList coords = geo instanceof IEnvelope ? ((IEnvelope)geo).toPolygone().getCoordinates() : geo.getCoordinates();
        int i2 = 0;
        while (i2 < coords.length() - 1) {
            if (Util.lineContainsPoint(coords.get(i2), coords.get(i2 + 1), p2.getCoordinate())) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    private static boolean lineStringIntersects(ILineString line, IGeometry geo) {
        if (geo instanceof IPolygon) {
            return OpIntersect.polygonIntersects((IPolygon)geo, line);
        }
        if (geo instanceof IPoint) {
            return OpContain.contains(line, (IPoint)geo);
        }
        if (geo instanceof IEnvelope) {
            return OpIntersect.polygonIntersects(((IEnvelope)geo).toPolygone(), line);
        }
        if (geo instanceof ILineString) {
            ISpatialCoordinateList linemax;
            ISpatialCoordinateList linemin;
            if (line.getCoordinates().length() < geo.getCoordinates().length()) {
                linemin = line.getCoordinates();
                linemax = geo.getCoordinates();
            } else {
                linemin = geo.getCoordinates();
                linemax = line.getCoordinates();
            }
            int i2 = 0;
            while (i2 < linemax.length() - 1) {
                int j2 = 0;
                if (j2 < linemin.length() - 1) {
                    return Util.segmentIntersection(linemax.get(i2), linemax.get(i2 + 1), linemin.get(i2), linemin.get(i2 + 1)) != null;
                }
                ++i2;
            }
        }
        return false;
    }

    private static boolean polygonIntersects(IPolygon poly, IGeometry geo) {
        if (geo instanceof IPoint) {
            return OpIntersect.pointIntersects((IPoint)geo, poly);
        }
        ISpatialCoordinateList geocoords = null;
        ISpatialCoordinateList polycoords = poly.getCoordinates();
        geocoords = geo instanceof IEnvelope ? ((IEnvelope)geo).toPolygone().getCoordinates() : geo.getCoordinates();
        return OpIntersect.lineStringIntersects(poly.getFactory().createLineString(polycoords), new LineString(geocoords));
    }

    public static boolean intersect(IGeometry geo1, IGeometry geo2) {
        if (geo1 instanceof IEnvelope) {
            return OpIntersect.envelopeIntersects((IEnvelope)geo1, geo2);
        }
        if (geo1 instanceof IPoint) {
            return OpIntersect.pointIntersects((IPoint)geo1, geo2);
        }
        if (geo1 instanceof ILineString) {
            return OpIntersect.lineStringIntersects((ILineString)geo1, geo2);
        }
        if (geo1 instanceof IPolygon) {
            return OpIntersect.polygonIntersects((IPolygon)geo1, geo2);
        }
        return false;
    }
}

