/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cst.ui.embedded.geometry.impl;

import com.ibm.cst.ui.embedded.factory.IGeometryFactory;
import com.ibm.cst.ui.embedded.geometry.IEnvelope;
import com.ibm.cst.ui.embedded.geometry.IPolygon;
import com.ibm.cst.ui.embedded.geometry.ISpatialCoordinate;
import com.ibm.cst.ui.embedded.geometry.impl.AbstractGeometry;
import com.ibm.cst.ui.embedded.geometry.impl.SpatialCoordinate;
import com.ibm.cst.ui.embedded.list.IGeometryList;
import com.ibm.cst.ui.embedded.list.ISpatialCoordinateList;

public class Polygon
extends AbstractGeometry
implements IPolygon {
    protected ISpatialCoordinateList $linearRing;
    protected int[] $trianglesIndices;
    protected IGeometryList trianglesList = null;
    protected IEnvelope envelope = null;
    private double areaCache = Double.NaN;
    private ISpatialCoordinate centroidCache = null;

    public Polygon(ISpatialCoordinateList ring, int[] trianglesIndices, IGeometryFactory factory) {
        super(factory);
        this.$linearRing = this.closeRing(ring);
        this.$trianglesIndices = this.adjustTriangles(trianglesIndices, this.$linearRing);
    }

    private final int[] adjustTriangles(int[] trianglesIndices, ISpatialCoordinateList ring) {
        if (trianglesIndices == null && ring.length() == 4) {
            int[] nArray = new int[3];
            nArray[1] = 1;
            nArray[2] = 2;
            trianglesIndices = nArray;
        }
        return trianglesIndices;
    }

    private final ISpatialCoordinateList closeRing(ISpatialCoordinateList ring) {
        int corners = ring.length();
        if (corners > 2) {
            ISpatialCoordinate firstPoint = ring.get(0);
            if (!ring.get(corners - 1).equals(firstPoint)) {
                ring.add(firstPoint);
            }
        }
        return ring;
    }

    public final int[] getTrianglesIndices() {
        return this.$trianglesIndices;
    }

    public final ISpatialCoordinate getCentroid() {
        if (this.centroidCache == null) {
            double cX = 0.0;
            double cY = 0.0;
            double areaDbl = 0.0;
            if (this.$linearRing.length() >= 4) {
                int i2 = 0;
                while (i2 < this.$linearRing.length() - 1) {
                    double trAreaDbl = this.$linearRing.get(i2).getX() * this.$linearRing.get(i2 + 1).getY() - this.$linearRing.get(i2 + 1).getX() * this.$linearRing.get(i2).getY();
                    areaDbl += trAreaDbl;
                    cX += (this.$linearRing.get(i2).getX() + this.$linearRing.get(i2 + 1).getX()) * trAreaDbl;
                    cY += (this.$linearRing.get(i2).getY() + this.$linearRing.get(i2 + 1).getY()) * trAreaDbl;
                    ++i2;
                }
            }
            this.centroidCache = new SpatialCoordinate(cX / (3.0 * areaDbl), cY / (3.0 * areaDbl));
            if (Double.isNaN(this.areaCache)) {
                this.areaCache = areaDbl / 2.0;
            }
        }
        return this.centroidCache;
    }

    public final ISpatialCoordinate getCoordinate() {
        return this.isEmpty() ? null : this.$linearRing.get(0);
    }

    public final ISpatialCoordinateList getCoordinates() {
        return this.$linearRing;
    }

    public final IEnvelope getEnvelope() {
        if (this.envelope == null) {
            this.envelope = this.getFactory().createEnvelope(this.getCoordinates());
        }
        return this.envelope;
    }

    public final boolean isEmpty() {
        return this.$linearRing == null;
    }

    public final boolean equals(Object o2) {
        return o2 instanceof IPolygon && this.$linearRing != null && this.$linearRing.equals(((IPolygon)o2).getCoordinates());
    }

    public final StringBuffer appendTo(StringBuffer sbuf) {
        if (sbuf == null) {
            sbuf = new StringBuffer();
        }
        sbuf.append("POLYGON40");
        ISpatialCoordinateList coords = this.getCoordinates();
        if (coords != null) {
            sbuf.append(coords.toString());
            int[] indices = this.getTrianglesIndices();
            if (indices != null) {
                sbuf.append(",TRIANGLES(");
                int iI = 0;
                while (iI < indices.length) {
                    if (iI != 0) {
                        sbuf.append('|');
                    }
                    sbuf.append(indices[iI]);
                    ++iI;
                }
                sbuf.append(')');
            } else {
                sbuf.append("NO TRIANGLES");
            }
        }
        sbuf.append(')');
        return sbuf;
    }
}

