/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cst.ui.embedded.geometry.impl;

import com.ibm.cst.ui.embedded.factory.IGeometryFactory;
import com.ibm.cst.ui.embedded.geometry.IEnvelope;
import com.ibm.cst.ui.embedded.geometry.IPoint;
import com.ibm.cst.ui.embedded.geometry.ISpatialCoordinate;
import com.ibm.cst.ui.embedded.geometry.impl.AbstractGeometry;
import com.ibm.cst.ui.embedded.list.ISpatialCoordinateList;

public final class Point
extends AbstractGeometry
implements IPoint {
    protected ISpatialCoordinate coordinate;

    public Point(ISpatialCoordinate coord, IGeometryFactory factory) {
        super(factory);
        this.coordinate = coord;
    }

    public final double getX() {
        return this.isEmpty() ? Double.NaN : this.coordinate.getX();
    }

    public final double getY() {
        return this.isEmpty() ? Double.NaN : this.coordinate.getY();
    }

    public final ISpatialCoordinate getCentroid() {
        return this.coordinate;
    }

    public final ISpatialCoordinate getCoordinate() {
        return this.coordinate;
    }

    public final ISpatialCoordinateList getCoordinates() {
        return this.getFactory().getListFactory().createSpatialCoordinateList(new ISpatialCoordinate[]{this.coordinate});
    }

    public final IEnvelope getEnvelope() {
        if (this.isEmpty()) {
            return this.getFactory().createEnvelope();
        }
        return this.getFactory().createEnvelope(this.getCoordinate().getX(), this.getCoordinate().getX(), this.getCoordinate().getY(), this.getCoordinate().getY());
    }

    public final boolean isEmpty() {
        return this.coordinate == null;
    }

    public final boolean equals(Object o2) {
        return o2 instanceof IPoint && this.coordinate != null && this.coordinate.equals(((IPoint)o2).getCoordinate());
    }

    public final StringBuffer appendTo(StringBuffer sbuf) {
        if (sbuf == null) {
            sbuf = new StringBuffer();
        }
        sbuf.append("POINT40");
        if (!this.isEmpty()) {
            sbuf.append(this.coordinate.toString());
        }
        sbuf.append(')');
        return sbuf;
    }
}

