/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cst.ui.embedded.geometry.impl;

import com.ibm.cst.ui.embedded.factory.IGeometryFactory;
import com.ibm.cst.ui.embedded.factory.impl.GeometryFactory;
import com.ibm.cst.ui.embedded.geometry.IEnvelope;
import com.ibm.cst.ui.embedded.geometry.IGeometry;
import com.ibm.cst.ui.embedded.geometry.ISpatialCoordinate;
import com.ibm.cst.ui.embedded.geometry.operator.OpContain;
import com.ibm.cst.ui.embedded.geometry.operator.OpIntersect;
import com.ibm.cst.ui.embedded.list.ISpatialCoordinateList;

public abstract class AbstractGeometry
implements IGeometry {
    static final IGeometryFactory _DefaultFactory = GeometryFactory.getInstance();
    private final IGeometryFactory _Factory;

    public AbstractGeometry(IGeometryFactory geoFactory) {
        this._Factory = geoFactory == null ? _DefaultFactory : geoFactory;
    }

    public final IGeometryFactory getFactory() {
        return this._Factory;
    }

    public final boolean intersects(IGeometry g2) {
        return OpIntersect.intersect(this, g2);
    }

    public final String toString() {
        return this.appendTo(null).toString();
    }

    public final boolean contains(IGeometry g2) {
        return OpContain.contains(this, g2);
    }

    public abstract boolean equals(Object var1);

    public abstract boolean isEmpty();

    public abstract ISpatialCoordinate getCoordinate();

    public abstract ISpatialCoordinateList getCoordinates();

    public abstract IEnvelope getEnvelope();

    public abstract ISpatialCoordinate getCentroid();

    public abstract StringBuffer appendTo(StringBuffer var1);
}

